package kochModel.visitor;

import fp.*;
import kochModel.*;

public class GrowVisitor implements IKochVisitor<Object, IFactory> {
  
  public static final GrowVisitor Singleton = new GrowVisitor();
  
  private GrowVisitor() {}
  
  private IFoldAlgo<Koch, Object, IFactory> foldAlgo = new IFoldAlgo<Koch, Object, IFactory>(){
    public Object apply( Koch host, Object base, IFactory... fac) {
      return host.execute(GrowVisitor.this, fac);
    }    
  };
  
  public Object baseCase(Koch host, IFactory... fac) {
    host.shareState(fac[0].makeInduct(host.getA(),host.getB()));
    return null;
  }
  
  public Object inductCase(Koch host, IFactory... fac) {
    return host.fold(foldAlgo, null, fac[0]);
  }
  
}